/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */
'use strict';

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'underscore', 'jquerymobile',
    'applets/wound-care-applet/core/extensions/list-generator/core/views/patients/PatientView',
    'applets/wound-care-applet/core/extensions/list-generator/core/views/SimpleListView' ],
    function (Portal, Backbone, Marionette, $, _, jqm) {
        var self, hasPaging;
        return Portal.module('ListGenerator', function (ListGenerator, Portal, Backbone, Marionette, $, _) {
            ListGenerator.WCListView = ListGenerator.RecentPatientListView.extend({
                
                initialize: function() {
                    self = this;
                    this.bootstrapPrepopulate();
                },
                onRender: function() {
                },
                fetchData: function(){
                    var data = {},

                        searchType = self.model.get('id'),
                        location,
                        startDate;

                    if ( self.model.has('location') ) {
                        location = self.model.get('location');

                        data.ward = location.get('id');
                    }
                    // return data;
                    var dataString = "?";
                    _.forEach(_.keys(data), function(key) {
                        dataString += key + "=" + data[key] + "&";
                    });
                    return dataString;
                },

                bootstrapPrepopulate :function () {
                    var data = this.fetchData();
                    // self.ui.autocompleteList.accessibleautocomplete( 'option', 'filterNoItemsMessage', self.noItemsMessage );

                    self.collection.fetch({
                        url: self.collection.url() + data,
                        dataType: "json",
                        //data: data
                    }).done( function ( response ) {
                        //if (self._isRendered) { self.renderHeader(); }

                        if ( !self.hasPaging ) {
                            $('#portal-modal .ui-content').on('scrollstop', function(e) {
                                self.fetchPage(e);
                            });
                            self.hasPaging = true;
                        }
                    }).fail( function ( jqXHR ) {
                        self.collection.reset();

                        if (jqXHR.status === 400) {
                            // list.accessibleautocomplete( 'option', 'filterNoItemsMessage', $.parseJSON(jqXHR.responseText).message );
                            self.hasPaging = false;
                        }
                    });

                },
                fetchPage: function(e) {

                    var nextPage = this.collection.latestPage + 1,
                        size = this.collection.results,
                        totalResults = this.collection.totalResults,
                        atEndOfPage = e.currentTarget.scrollHeight - e.currentTarget.scrollTop <= e.currentTarget.clientHeight + 100;

                    if ( atEndOfPage && size < totalResults ) {
                        //var data = _.extend({page: nextPage}, this._autocomplete().fetchData());
                        var data = this._autocomplete().fetchData() + "page=" + nextPage;

                        this.collection.fetch({
                            url: self.collection.url() + data,
                            remove: false,
                            dataType: "json",
                            //data: data
                        })
                            .done( function ( response ) {
                                // patients appended by Marionette
                                //if (self._isRendered) { self.renderHeader(); }
                            });
                    } else if ( size === totalResults ) {
                        $('#portal-modal .ui-content').off('scrollstop');
                        self.hasPaging = false;
                    }
                }
            });
        });
    });